<?php
/**
 * Custom Tables
 *
 * @package     AutomatorWP\Restrict Content\Custom_Tables
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/custom-tables/access-levels.php';
require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/custom-tables/access-level-users.php';

/**
 * Register all custom database Tables
 *
 * @since   1.0.0
 *
 * @return void
 */
function automatorwp_restrict_content_register_custom_tables() {

    // Restrict Content
    ct_register_table( 'automatorwp_restrict_content_access_levels', array(
        'singular' => __( 'Access Level', 'automatorwp-pro' ),
        'plural' => __( 'Access Levels', 'automatorwp-pro' ),
        'show_ui' => true,
        'show_in_rest' => true,
        'rest_base' => 'automatorwp-restrict-content-access-levels',
        'version' => 1,
        'capability' => automatorwp_get_manager_capability(),
        //'supports' => array( 'meta' ),
        'views' => array(
            'list' => array(
                'menu_title' => __( 'Access Levels', 'automatorwp-pro' ),
                'parent_slug' => 'automatorwp',
                'admin_bar' => true,
                'admin_bar_parent' => 'automatorwp-add-ons',
            ),
        ),
        'schema' => array(
            'id' => array(
                'type' => 'bigint',
                'length' => '20',
                'auto_increment' => true,
                'primary_key' => true,
            ),
            'name' => array(
                'type' => 'text',
            ),
            'slug' => array(
                'type' => 'text',
            ),
        ),
    ) );

    // Restrict Content > User
    ct_register_table( 'automatorwp_restrict_content_access_level_users', array(
        'singular' => __( 'User', 'automatorwp-pro' ),
        'plural' => __( 'Users', 'automatorwp-pro' ),
        'show_ui' => true,
        'show_in_rest' => false,
        'rest_base' => 'automatorwp-restrict-content-access-level-user',
        'version' => 1,
        'capability' => automatorwp_get_manager_capability(),
        //'supports' => array( 'meta' ),
        'views' => array(
            'list' => array(
                'show_in_menu' => false,
            ),
        ),
        'schema' => array(
            'id' => array(
                'type' => 'bigint',
                'length' => '20',
                'auto_increment' => true,
                'primary_key' => true,
            ),
            'access_level_id' => array(
                'type' => 'bigint',
                'length' => '20',
                'key' => true,
            ),
            'user_id' => array(
                'type' => 'bigint',
                'length' => '20',
                'key' => true,
            ),
        ),
    ) );

}
add_action( 'ct_init', 'automatorwp_restrict_content_register_custom_tables' );